/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import <Foundation/Foundation.h>

/*
 
 PRZYCISK    APARAT        DANE       NATURALNE       ODBICIE           ORIENTACJA
 POCZĄTEK                WYJŚCIOWE
 Na dole      Z przodu    W prawo    Lewe odbicie     W prawo            Pionowa
 Po prawej    Z przodu    W dół      Odbicie w dół    W dół              Pozioma w lewo
 Na górze     Z przodu    W lewo     Prawe odbicie    W lewo             Odwrócona pionowo
 Po lewej     Z przodu    W górę     Odbicie w górę   W górę             Pozioma w prawo
 
 Na dole      Z tyłu      W prawo    W prawo          Lewe odbicie       Pionowa
 Po prawej    Z tyłu      W górę     W górę           Odbicie w górę     Pozioma w lewo
 Na górze     Z tyłu      W lewo     W lewo           Prawe odbicie      Odwrócona pionowo
 Po lewej     Z tyłu      W dół      W dół            Odbicie w dół      Pozioma w prawo
 
 DOSTĘPNE ORIENTACJE: EXIF i UIImageOrientation
 
 góra, lewo   góra, prawo   dół, prawo   dół, lewo    lewo, góra   prawo, góra   prawo, dół   lewo, dół
 EXIF 1       2             3            4            5            6             7            8
 
 XXXXXX  XXXXXX      XX  XX      XXXXXXXXXX  XX                  XX  XXXXXXXXXX
 XX          XX      XX  XX      XX  XX      XX  XX          XX  XX      XX  XX
 XXXX      XXXX    XXXX  XXXX    XX          XXXXXXXXXX  XXXXXXXXXX          XX
 XX          XX      XX  XX
 XX          XX  XXXXXX  XXXXXX
 
 UI 0        4               1       5               6             2        7              3
 w górę   odbicie w górę  w dół   odbicie w dół   lewe odbicie  w lewo   prawe odbicie  w prawo
 
 
 
 MAPOWANIE POMIĘDZY ORIENTACJAMI:
 
 {1, 3, 6, 8, 2, 4, 5, 7};  EXIF
 {0  1  2  3  4  5  6  7}   UIIMG
 
 {1  2  3  4  5  6  7  8}   EXIF
 {0, 4, 1, 5, 6, 2, 7, 3};  UIIMG
 
 */

// ORIENTACJE EXIF
typedef enum {
    kTopLeft			= 1, // UIImageOrientationUp,           (0,0) w lewym górnym rogu
    kTopRight           = 2, // UIImageOrientationUpMirrored,   (0,0) w prawym górnym rogu
    kBottomRight        = 3, // UIImageOrientationDown          (0,0) w prawym dolnym rogu
    kBottomLeft         = 4, // UIImageOrientationDownMirrored  (0,0) w lewym dolnym rogu
    kLeftTop            = 5, // UIImageOrientationLeftMirrored  (0,0) w lewym górnym rogu
    kRightTop           = 6, // UIImageOrientationLeft          (0,0) w prawym górnym rogu
    kRightBottom        = 7, // UIImageOrientationRightMirrored (0,0) w prawym dolnym rogu
    kLeftBottom         = 8  // UIImageOrientationRight         (0,0) w lewym dolnym rogu
} ExifOrientation;

/*
 
 ORIENTACJE UIIMAGE
 
 typedef enum {
 UIImageOrientationUp =            0, // obrót o 0 stopni exif 1
 UIImageOrientationDown =          1, // obrót o 180 stopni exif 3
 UIImageOrientationLeft =          2, // obrót o 90 stopni (przeciwnie do kierunku ruchu wskazówek zegara) exif 6
 UIImageOrientationRight =         3, // obrót o 90 stopni (zgodnie z kierunkiem ruchu wskazówek zegara) exif 8
 UIImageOrientationUpMirrored =    4, // poziome odbicie exif 2
 UIImageOrientationDownMirrored =  5, // poziome odbicie exif 4
 UIImageOrientationLeftMirrored =  6, // pionowe odbicie exif 5
 UIImageOrientationRightMirrored = 7, // pionowe odbicie exif 7
 } UIImageOrientation;
 */

/*
 
 ORIENTACJE URZĄDZENIA
 
 UIDeviceOrientationUnknown
 Nie można ustalić orientacji urządzenia.
 UIDeviceOrientationPortrait
 Orientacja pionowa, przycisk Początek znajduje się na dole.
 UIDeviceOrientationPortraitUpsideDown
 Orientacja pionowa, przycisk Początek znajduje się na górze.
 UIDeviceOrientationLandscapeLeft
 Orientacja pozioma, przycisk Początek znajduje się po prawej stronie.
 UIDeviceOrientationLandscapeRight
 Orientacja pozioma, przycisk Początek znajduje się po lewej stronie.
 UIDeviceOrientationFaceUp
 Urządzenie leży na podłożu, ekranem do góry.
 UIDeviceOrientationFaceDown
 Urządzenie leży na podłożu, ekranem do dołu.
 */

// FUNKCJE POMOCNICZE

NSString *imageOrientationNameFromOrientation(UIImageOrientation orientation);
NSString *imageOrientationName(UIImage *anImage);
NSString *exifOrientationNameFromOrientation(uint orientation);
NSString *deviceOrientationName(UIDeviceOrientation orientation);
NSString *currentDeviceOrientationName();

BOOL deviceIsLandscape();
BOOL deviceIsPortrait();

uint exifOrientationFromUIOrientation(UIImageOrientation uiorientation);
UIImageOrientation imageOrientationFromEXIFOrientation(uint exiforientation);

UIImageOrientation currentImageOrientation(BOOL isUsingFrontCamera, BOOL shouldMirrorFlip);
uint currentEXIFOrientation(BOOL isUsingFrontCamera, BOOL shouldMirrorFlip);

// Istnieje ogromny błąd: gdy urządzenie jest w orientacji pionowej tylny aparat nie ustawia
// prawidłowej orientacji EXIF. Poniższa funkcja jest rozwiązaniem problemu,
// ale musisz odpowiednio dostosować orientację.
uint detectorEXIF(BOOL isUsingFrontCamera, BOOL shouldMirrorFlip);
